# coding: utf-8

"""tesdat is a package to generate testdata.
"""

__author__ = 'crohaco (crohaco.net@gmail.com)'
__version__ = '1.1.0'
__license__ = 'PSF License'

from .container.list import ListContainer
from .container.dict import DictContainer

from .model.list import ListModel
from .model.dict import DictModel

from .pattern.choice import ChoicePattern
from .pattern.limited_choice import LimitedChoicePattern
from .pattern.cycle import CyclePattern
from .pattern.hash import HashPattern
from .pattern.increment import IncrementPattern


def Model(params):  # NOQA
    if isinstance(params, dict):
        return DictModel(params)
    elif isinstance(params, list):
        return ListModel(params)


def set_json_indent(indent=4):
    from .container import base
    base.json_indent = indent


def add_json_encoder(type, encoder):
    from .container import base
    base.JSONEncoder.encoder_map[type] = encoder

try:
    del container, model, pattern
except NameError:
    pass
