# coding: utf-8

from .base import BaseContainer, iterize
from ..common import render


class ListContainer(BaseContainer, list):
    def render(self, iterable=None):
        """
        generate record to self(list container).
        >>> g = (v for v in ['a', 'b', 'c'])
        >>> lc = ListContainer(g.next).repeat(3)
        >>> lc.render()
        ['a', 'b', 'c']

        :param iterable: iterable object or int.
            element of in iterable-object basically does not affect rendering the record.
        :return: rendered container.
        """
        for i, value in enumerate(iterize(iterable) or self.iterable):
            args = [i, value]
            self.append(render.apply(self.blueprint, args, [None]))
        return self
