# coding: utf-8

from unittest import TestCase


def gen_value(element, seq_num, seq_key):
    return str(element[1]) + ' + ' + (str(seq_key) * seq_num)


class TestListModel(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..list import ListModel
        return ListModel(*args, **kwargs)

    def test_order(self):
        le = self._getClass(['a', 'b', 'c', 'd'])
        le.ordering(3, 2)
        self.assertEqual(le.order, [3, 2, 0, 1])

    def test_render(self):
        try:
            from ...pattern.increment import IncrementPattern
        except ValueError:
            try:
                from pattern.increment import IncrementPattern
            except ImportError:
                return

        le = self._getClass([
            gen_value,
            IncrementPattern(),
            3
        ]).ordering(1)

        self.assertEqual(
            [
                le.render(i, key)
                for i, key in enumerate(['a', 'b', 'c'])
            ],
            [
                ['1 + ', 1, 3],
                ['2 + b', 2, 3],
                ['3 + cc', 3, 3]
            ],
        )

    def test_render_nesting(self):
        lm = self._getClass([
            1,
            self._getClass([2, 3])
        ])

        self.assertEqual(
            [
                lm.render(i, key)
                for i, key in enumerate(range(3))
            ],
            [[1, [2, 3]]] * 3
        )

    def test_custom_render(self):
        try:
            from ...pattern.increment import IncrementPattern
        except ValueError:
            try:
                from pattern.increment import IncrementPattern
            except ImportError:
                return

        lm = self._getClass([
            (lambda record: str(record[1])),
            IncrementPattern()
        ]).ordering(1)

        self.assertEqual(
            [
                lm.render(i, key)
                for i, key in enumerate(range(3))
            ],
            [['1', 1], ['2', 2], ['3', 3]]

        )
