# coding: utf-8

from unittest import TestCase


class TestChoicePattern(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..choice import ChoicePattern as Pattern
        return Pattern(*args, **kwargs)

    def test_choice_pattern_receive_list_choices(self):
        choices = [2, 4, 6]
        expect = map(str, choices)
        pattern = self._getClass(choices, str)
        for i in range(100):
            self.assertIn(pattern.render(), expect)

    def test_choice_pattern_dict_choices(self):
        choices = {'a': 1, 'b': 2, 'c': 3}
        expect = choices.keys()
        pattern = self._getClass(choices, str)
        for i in range(100):
            self.assertIn(pattern.render(), expect)

