# coding: utf-8

from unittest import TestCase


class TestLimitedChoicePattern(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..limited_choice import LimitedChoicePattern as Pattern
        return Pattern(*args, **kwargs)

    def test_limited_choice_pattern_receive_list_choices(self):
        choices = [2, 4, 6]
        expect = map(str, choices)
        pattern = self._getClass(choices, missing=0, callback=str)
        for i in range(3):
            self.assertIn(pattern.render(), expect)

        self.assertEqual(pattern.render(), '0')

    def test_limited_choices_pattern_receive_dict_choices(self):
        choices = {'a': 1, 'b': 2, 'c': 3}
        pattern = self._getClass(choices)
        expect = ['a', 'b', 'c']
        for i in range(6):
            self.assertIn(pattern.render(), expect)

        self.assertIsNone(pattern.render())

