# coding: utf-8

from ..container.base import BaseContainer
from ..model.base import BaseModel
from ..pattern.base import BasePattern


def apply(blueprint, args, args_prefix=[]):
    """rendering arguments adujuster
    :param blueprint: pattern/model/container/function
    :param args: render arguments
    :param args_prefix: args_prefix
    :return: rendered record
    """
    # num arguments adjustment for custom function
    _args = args + args_prefix
    if isinstance(blueprint, BasePattern):
        record = blueprint.render(*_args)
    elif isinstance(blueprint, BaseModel):
        record = blueprint.render(_args[1], _args[2])
    elif isinstance(blueprint, BaseContainer):
        record = blueprint.render()
    elif callable(blueprint):
        for i in (0, 1, 2, 3):
            try:
                record = blueprint(*args[:i])
                break
            except TypeError:
                # occur by arguments excess
                pass
    else:
        record = blueprint

    return record
