# coding: utf-8

from .base import BaseContainer, iterize
from ..common import render


class DictContainer(BaseContainer, dict):
    def render(self, iterable=None):
        """
        generate record to self(dict container).
        >>> g = (i for i in [1, 2, 3])
        >>> dc = DictContainer(g.next).repeat(['a', 'b', 'c'])
        >>> dc.render()
        {'a': 1, 'c': 3, 'b': 2}

        :param iterable: iterable object or int. element of in iterable-object become key.
        :return: rendered container.
        """
        for i, value in enumerate(iterize(iterable) or self.iterable):
            args = [i, value]
            self[value] = render.apply(self.blueprint, args, [None])
        return self
