# coding: utf-8

from unittest import TestCase


class TestDictContainer(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..dict import DictContainer
        return DictContainer(*args, **kwargs)

    def test_render_element_is_function(self):
        def test_function(i, value):
            return [value] * i

        dc = self._getClass(test_function)
        dc.render(['a', 'b', 'c'])
        self.assertEqual(
            dc,
            {
                'a': [],
                'b': ['b'],
                'c': ['c', 'c'],
            }
        )

    def test_render_normal_element(self):
        try:
            from ...model.list import ListModel
        except ValueError:
            try:
                from model.list import ListModel
            except ImportError:
                return

        lm = ListModel([1, 2])
        dc = self._getClass(lm)
        dc.render(['a', 'b', 'c'])
        self.assertEqual(
            dc,
            {
                'a': [1, 2],
                'b': [1, 2],
                'c': [1, 2],
            }
        )


class TestOrderedDictContainer(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..dict import OrderedDictContainer
        return OrderedDictContainer(*args, **kwargs)

    def test_render_element_is_function(self):
        def test_function(i, value):
            return value * i

        dc = self._getClass(test_function)
        keys = ['a', 'b', 'c', 'd', 'e']
        dc.render(keys)
        index = 0
        for key, value in dc.items():
            self.assertEqual(key, keys[index])
            self.assertEqual(value, key * index)

            index += 1
