# coding: utf-8

from .base import BasePattern
from random import choice


class ChoicePattern(BasePattern):
    """
    select an element randomly from the choices.
    """
    def __init__(self, choices, callback=None):
        """
        :param choices: list-elements of choices
        :param callback: function to be called at the end of rendering.
        :return: Choice Pattern instance.
        """
        if isinstance(choices, dict):
            self.choices = []
            for value, num in choices.items():
                self.choices += [value] * num
        else:
            self.choices = choices
        self.add_callback(callback)

    def render(self, *args):
        """
        render a element by randomly selection
        :param args: any.
        :return: rendered element.
        """
        element = choice(self.choices)
        for callback in self.callbacks:
            element = callback(element)
        return element
