# coding: utf-8

from .base import BasePattern
from random import choice, randint


class LimitedChoicePattern(BasePattern):
    """
    select an element randomly from the limited-choices.
    """
    def __init__(self, choices, missing=None, callback=None):
        """
        :param choices: list-elements of choices / dict element(key): element_count(value)
        :param missing: return this value if choices is blank.
        :param callback: function to be called at the end of rendering.
        :return: Choice Pattern instance.
        """
        if isinstance(choices, dict):
            self.choices = []
            for value, num in choices.items():
                self.choices += [value] * num
        else:
            self.choices = list(choices)
        self.missing = missing
        self.add_callback(callback)

    def render(self, *args):
        """
        render a element by randomly selection
        :param args: any.
        :return: rendered element.
        """
        last_index = len(self.choices) - 1
        if last_index == -1:
            return self.missing

        pop_index = randint(0, last_index)
        element = self.choices.pop(pop_index)

        for callback in self.callbacks:
            element = callback(element)
        return element
