# coding: utf-8

from .base import BasePattern


class SequencePattern(BasePattern):
    """
    select an element sequentially.
    """
    def __init__(self, sequence, missing=None, callback=None):
        """
        :param sequence: list-elements of sequence / dict element(key): element_count(value)
        :param missing: return this value if reached last element.
        :param callback: function to be called at the end of rendering.
        :return: Choice Pattern instance.
        """
        if isinstance(sequence, dict):
            self.sequence = []
            for value, num in sequence.items():
                self.sequence += [value] * num
        else:
            self.sequence = sequence
        self.size = len(self.sequence) - 1
        self.missing = missing
        self.index = 0
        self.add_callback(callback)

    def render(self, *args):
        """
        render a element
        :param args: any.
        :return: rendered element.
        """
        if self.index > self.size:
            return self.missing

        element = self.sequence[self.index]
        self.index += 1
        for callback in self.callbacks:
            element = callback(element)
        return element
