# coding: utf-8

from unittest import TestCase


class TestCyclePattern(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..cycle import CyclePattern as Pattern
        return Pattern(*args, **kwargs)

    def test_cycle_pattern(self):
        pattern = self._getClass([1, 2, 3], callback=str)
        self.assertEqual(
            [pattern.render() for i in range(5)],
            ['1', '2', '3', '1', '2']
        )

    def test_cycle_pattern_receive_dict_choices(self):
        from collections import OrderedDict
        choices = OrderedDict()
        for k, v in [('a', 1), ('b', 2), ('c', 3)]:
            choices[k] = v
        pattern = self._getClass(choices)
        self.assertEqual(
            [pattern.render() for i in range(10)],
            [
                'a',
                'b', 'b',
                'c', 'c', 'c',
                'a',
                'b', 'b',
                'c',
            ]
        )