# coding: utf-8

from unittest import TestCase


class TestHashPattern(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..hash import HashPattern as Pattern
        return Pattern(*args, **kwargs)

    def test_hash_pattern_normal(self):
        import hashlib
        pattern = self._getClass('a', 'md5')

        record = {'a': 1}
        value = pattern.render(record)
        self.assertEqual(
            value,
            hashlib.md5('1').hexdigest()
        )
