# coding: utf-8

from unittest import TestCase


class TestLimitedChoicePattern(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..sequence import SequencePattern as Pattern
        return Pattern(*args, **kwargs)

    def test_sequence_pattern_receive_list_choices(self):
        choices = [2, 4, 6]
        expect = map(str, choices)
        pattern = self._getClass(choices, missing=0, callback=str)
        for i in range(3):
            self.assertIn(pattern.render(), expect)

        self.assertEqual(pattern.render(), 0)

    def test_sequence_pattern_receive_dict_choices(self):
        from collections import OrderedDict
        choices = OrderedDict()
        for k, v in [('a', 1), ('b', 2), ('c', 3)]:
            choices[k] = v
        pattern = self._getClass(choices, missing='z')
        self.assertEqual(
            [pattern.render() for i in range(10)],
            [
                'a',
                'b', 'b',
                'c', 'c', 'c',
                'z', 'z', 'z', 'z'
            ]
        )