#!/usr/bin/env python
# -*- coding: latin-1 -*- vim: ts=8 sts=4 sw=4 si et tw=79
"""\
Python-Template v0.1
"""

__author__ = "Tobias Herp <tobias.herp@gmx.net>"
VERSION = (0,
           1,   # initial version
           'rev-%s' % '$Rev: 839 $'[6:-2],
           )
__version__ = '.'.join(map(str, VERSION))
try:
    from enhopa import OptionParser, OptionGroup
except ImportError:
    from optparse import OptionParser, OptionGroup

from os.path import normpath, normcase
import sys
import string
from errors import error, check_errors

p = OptionParser(version='.'.join(map(str, VERSION)),
                 usage='%prog [-bNN] {Datei} [...]',
                 description=u'Lies die ersten -b Bytes jeder bergebenen'
                 ' Datei und gib sie aus')
g = OptionGroup(p, "Specific options")
g.add_option('-b', '--bytes',
             action='store',
             metavar='NN',
             default=16,
             type='int', # vorerst
             help='Anzahl der aus jeder Datei zu lesenden Bytes'
             u' (eine natrliche Zahl; (noch?) keine Suffixe untersttzt)'
             '; default: %default')
p.add_option_group(g)
p.add_option('-v', '--verbose',
             action='count',
             help='be verbose (-vv: even more verbose)')
try:
    p.set_collecting_group()
except AttributeError:
    pass
option, args = p.parse_args()

if not args:
    error('keine Dateien angegeben - nichts zu tun!')

def normalname(f):
    if f == '-':
        return f
    return normpath(f)

args = map(normalname, args)
align = max(map(len, args))
stdin_name = 'Standardeingabe'
if '-' in args:
    align = max(align, len(stdin_name))
align += 1

class FilesystemSingleton:
    def __init__(self):
        self.repo = set()

    def __call__(self, name):
        name = normcase(name)
        if name in self.repo:
            return 1
        else:
            self.repo.add(name)
            return 0

done = FilesystemSingleton()

def format_groupedbytes(d):
    res = ['%02x' % ord(ch) for ch in d]
    top = (len(res)-1) // 4 * 4
    for idx in range(top, 0, -4):
        res.insert(idx, ' ')
    return ' '.join(res)

def format_singlebytes(d):
    return ' '.join(['%02x' % ord(ch) for ch in d])

def printable_char(ch):
    if ch in '\r\n\t':
        return '?'
    elif ch in string.printable:
        return ch
    else:
        return '?'

def format_readable_and_grouped(d):
    res = [printable_char(ch)
           for ch in d]
    if len(res) < option.bytes:
        res.extend(list(' '*(option.bytes - len(res))))
    if 0:
        top = (len(res)-1) // 4 * 4
        for idx in range(top, 0, -4):
            res.insert(idx, ' ')
    res.append('   ')
    res.append(format_groupedbytes(d))
    return ''.join(res)

formatter = format_readable_and_grouped

for f in args:
    if done(f):
        continue
    try:
        if f == '-':
            f = stdin_name
            data = sys.stdin.read(option.bytes)
        else:
            data = open(f, 'rb').read(option.bytes)
        print '%-*s %s' % (align, f+':', formatter(data))
    except IOError, e:
        error(e)
    except OSError, e:
        error(e)
