from os import listdir,walk,path,environ
from config import TiConfig as ctznConfig
from titantools.orm import TiORM as ctznORM

# Get titanOSX Env and Config
CTZNOSX_PATH = (environ.get('CTZNOSX_PATH') or '/var/lib/ctznosx/')
CTZNOSX_CONFIG = path.join('/etc/', 'ctznosx.conf')

# Config
CONFIG = ctznConfig( CTZNOSX_CONFIG, CTZNOSX_PATH )
DATASTORE = CONFIG['main']['datastore']

# Run Report
def run():
    report = ""

    # Load ORM 
    ORM = ctznORM(DATASTORE)

    # Get all tables
    all_monitors = ORM.select('sqlite_master', 'name',  "type = 'table' and name != 'watcher'")
    for monitor in all_monitors:
        report += "<h2>%s</h2>" % monitor['name']
        module_data = ORM.select( monitor['name'], '*' )
        
        report += "<table>"
        for row in module_data:
            report += "<tr>"
            for column in row:
                report += "<td>"
                report += column
                report += "</td>"

                report += "<td>"
                report += str(row[str(column)])
                report += "</td>"
            report += "</tr>"
        report += "</table>"

    report += helpers.footer()

    print report

