
"""
  ____             _             
 | __ ) _ __ _   _| |_ _   _ ___ 
 |  _ \| '__| | | | __| | | / __|
 | |_) | |  | |_| | |_| |_| \__ \
 |____/|_|   \__,_|\__|\__,_|___/
                                                
v1.0.0
By David Hacker (dmhacker)

Brutus is the standard bot. Although slow, it will answer with 100% accuracy.
Its name stems from the fact that it employs a traditional brute force algorithm to evaluate every possible solution.
Recommended improvements include reducing the search space and memoizing. 

"""
class Robot:
    
    def find_word(self, grid, word):
        
        # List of all the characters in the given word
        chars = list(word)
        
        # Length of the grid
        grid_length = 9
        
        # Map pairing tuples with respective characters in format: {coord:char}
        gridmap = {}
        for x in xrange(0, grid_length):
            for y in xrange(0, grid_length):
                # Reversed because we found the row (y) before the column (x)
                gridmap[(x,y)] = grid[y][x] 
        
        # Possible x-y distances between nodes
        directions = [
                      (0, 1), (0, -1), (1, 0), (-1, 0),
                      (1, 1), (-1, -1), (-1, 1), (1, -1)
                      ]
        
        # Function for adding the content of two tuples together
        def add_tuples(t1, t2):
            return (t1[0]+t2[0], t1[1]+t2[1])
        
        # Returns all the points surrounding the given point
        def points_around(point):
            points = []
            for direction in directions:
                points.append(add_tuples(point, direction))
            return points
        
        # Determines whether the given point is on the grid
        def is_valid(point):
            return 0 <= point[0] < grid_length and 0 <= point[1] < grid_length
        
        # Determine a list of all possible paths from every point that fit the desired amount of characters
        paths = []
        for start, char in gridmap.iteritems():
            for direction in directions:
                path = []
                for i in xrange(0, len(chars)):
                    xdelta = direction[0] * i
                    ydelta = direction[1] * i
                    node = add_tuples(start, (xdelta, ydelta))
                    path.append(node)
                paths.append(path)
           
        # Narrows paths down to only valid ones   
        possible_paths = []
        for path in paths:
            if not [x for x in path if not is_valid(x)]:
                possible_paths.append(path)
            
        # Find the correct path. 
        # The final list should only have one element unless there is a collision (two paths were generated).
        correct_paths = []
        for path in possible_paths:
            new_chars = []
            for point in path:
                new_chars.append(gridmap[point])
            if ''.join(new_chars) == word:
                correct_paths.append(path)
                
        if correct_paths:
            return correct_paths[0]
        return ['This should not happen!']
                    
                    
                    
                    
                    