# -*- coding: utf-8 -*-
"""
title           : brdf_multidir.py
description     : script using the ADAM Toolkit demonstating taking making BRDF calculations
                  for multiple phi values
author          : Ivan.Price@noveltis.fr
date            : Tue Jul 31 16:55:26 2012
version         : 0.1
usage           : python brdf_multidir.py
notes           :
"""



import numpy as np
import sys


# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')


# import the adam libraries
import adam
import adam_config as adam_config


#my_path_data       = '/home/satellites9/cbacour/ADAM/Data/V1/'
#my_output_root_dir = '/home/satellites9/cbacour/ADAM/OUTPUT/'

# get an instance of an adam 'config' object, this will be attached to any jobs we run
#my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
my_config = adam_config.adam_config()


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = { 'fieldOperationType': 'brdf',
                 'fieldSpectralDomain': '860-860 nm',
                 'fieldBRType': 'principal',
                 'fieldSunZenith': 0,
                 'fieldViewZenith': 0,
                 'fieldRelAzimuth': 0,
                 'fieldMonth': 'jan',


                # land
                 'fieldCorner1Lat'   : 20.3,
                 'fieldCorner1Lon'   : 0.4,
                 'fieldCorner2Lat'   : 20.,
                 'fieldCorner2Lon'   : 0

                # ocean
#                 'fieldCorner1Lat'   : 0,
#                 'fieldCorner1Lon'   : 0,
#                 'fieldCorner2Lat'   : 0.4,
#                 'fieldCorner2Lon'   : 0.4

                # snow
#                'fieldCorner1Lat'   : 63.3,
#                'fieldCorner1Lon'   : 27.2,
#                'fieldCorner2Lat'   : 63.5,
#                'fieldCorner2Lon'   : 27.6
                }

# initialise the job, providing us with a blank object ('job') to work with
print 'init job/config'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')




# now we are ready to load the data from our source database into our job object
print 'load data...'
job.load_data()

# print a little output to prove we know where we are in the world
print "%s land pixels, %s ocean pixels, %s snow pixels" % (len(job.data['idx_land']),
                                                           len(job.data['idx_ocean']),
                                                           len(job.data['idx_snow']))

# call the convenience functions to populate the various variables
print 'perform reflectance calc...'
job.process_reflectance()

PHI_VALUES        = np.array(range(0,10))
VZA_VALUES        = np.array([1,5,10])
job.phi = PHI_VALUES
job.vza = VZA_VALUES

print '\n\nperform BRDF calc...'
job.process_brdf_averaged(lmbd=job.lmbd, do_spectral_averaging=True)

job.save_netcdf()

