# -*- coding: utf-8 -*-
"""
title           : brdf_graph.py
description     : script using the ADAM Toolkit demonstating taking making BRDF graphs
author          : Ivan.Price@noveltis.fr
date            : Tue Jul 31 16:55:26 2012
version         : 0.1
usage           : python brdf_graph.py
notes           :
"""



import numpy as np
import sys


# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')


# import the adam libraries
import adam
import adam_config as adam_config


# my_path_data       = 'p://3895-ADAM/code/data/'
# my_output_root_dir = 'Y://web-root/adam/web-output/'

#my_path_data       = '/home/satellites9/cbacour/ADAM/Data/V1/'
#my_output_root_dir = '/home/satellites9/cbacour/ADAM/OUTPUT/'

# get an instance of an adam 'config' object, this will be attached to any jobs we run
#my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
my_config = adam_config.adam_config()


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = { 'fieldOperationType': 'brdf',
                 'fieldSpectralDomain': '850-860 nm',
                 'fieldBRType': 'polar',
                 'fieldSunZenith': 45,
                 'fieldViewZenith': 0,
                 'fieldRelAzimuth': 0,
                 'fieldMonth': 'jan',

#                 'fieldCorner1Lat'   : 37.1,
#                 'fieldCorner1Lon'   : -3.6,
#                 'fieldCorner2Lat'   : 36.3,
#                 'fieldCorner2Lon'   : -3.5

#                'fieldCorner1Lon': '-4.1',
#                'fieldCorner2Lon': '-3.6',
#                'fieldCorner2Lat': '37.5',
#                'fieldCorner1Lat': '37.1'
                
                #water
                'fieldCorner1Lat': '43.1',
                'fieldCorner2Lon': '-42.3',
                'fieldCorner2Lat': '42.5',
                'fieldCorner1Lon': '-41.9'
                }

# initialise the job, providing us with a blank object ('job') to work with
print 'init job/config'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')


# now we are ready to load the data from our source database into our job object
print 'load data...'
job.load_data()

# print a little output to prove we know where we are in the world
print "%s land pixels, %s ocean pixels, %s snow pixels" % (len(job.data['idx_land']),
                                                           len(job.data['idx_ocean']),
                                                           len(job.data['idx_snow']))

# call the convenience functions to populate the various variables
print 'perform reflectance calc...'
job.process_reflectance()

# Increase vza sampling depending on sza (increase resolution near sza)
print 'define_vza_hotspot...'
job.define_vza_hotspot()

job.phi = np.linspace(0,100)

print 'Perform BRDF calculation...'
# populates job.data['BRDF'] and job.data['BRDF_err_land']
job.process_brdf(do_spectral_averaging=True)


job.save_netcdf()
from matplotlib import pylab

pylab.plot(job.vza, job.data['BRDF'][0,0,0,:,0])
pylab.show()
