# -*- coding: utf-8 -*-

"""
Created on Thu Dec 15 09:15:47 2011

script intended to be run from the commandline/IDE to demonstrate the use of the adam_job class

"""

import sys

# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')

# import the main adam library
import adam

import adam_config as adam_config


my_path_data       = 'p://3895-ADAM/code/data/'
my_output_root_dir = 'Y://web-root/adam/web-output/'
# get an instance of an adam 'config' object, this will be attached to any jobs we run
my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = {'fieldOperationType': 'spectrum',
                'fieldMonth'        : 'jan',
                'fieldSunZenith'    : 40,
                'fieldViewZenith'   : 30,
                'fieldRelAzimuth'   : 0,

                # land / ocean pixels
 #               'fieldCorner1Lat'   : 37.2,
#                'fieldCorner1Lon'   : -3.7,
  #              'fieldCorner2Lat'   : 36.4,
   #             'fieldCorner2Lon'   : -2.9
                
                'fieldCorner1Lon': '-4.1',
                'fieldCorner2Lon': '-2.6',
                'fieldCorner2Lat': '37.5',
                'fieldCorner1Lat': '36.8'



                }




# initialise the job, providing us with a blank object ('job') to work with
print 'initialise job..'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')

# now we are ready to load the data from our source database into our job object
print 'loading data..'
job.load_data()



# print a little output to prove we know where we are in the world
print "%s land pixels, %s ocean pixels, %s snow pixels" % (len(job.data['idx_land']),
                                                           len(job.data['idx_ocean']),
                                                           len(job.data['idx_snow']))


# call the convenience functions to populate the various variables
print 'calculate reflectance..'
# populates job.data['reflectance']
job.process_reflectance()

#job.spectral_domains = job.cfg.spectral_domains
print 'calculate brdf..'
job.process_brdf(do_spectral_averaging=False)


# now we can make our graphs
print 'make graphs..'
if job.is_pixel_request():
    print 'generating pixel graphs'
    # unlike ocean and snow, land spectrum graphs are treated one graph per pixel
    for i, pixel_index in enumerate(job.data['idx_land']):
        #idx = np.array([pixel_index])
        idx = [pixel_index]
        # the land error matrix is only populated for land pixels, so it uses a different counter
        job.graph_main_ref_spectra(case='pixels', indices=idx, title='Land pixel statistics', graph_error_indices=i)

    job.graph_main_ref_spectra(case='pixels', indices=job.data['idx_snow'],  title='Snow pixel statistics')
    job.graph_main_ref_spectra(case='pixels', indices=job.data['idx_ocean'], title='Ocean pixel statistics')
else:
    print 'generating stats graphs'
    job.calculate_stats(job.data['BRDF'])
    job.graph_main_ref_spectra(case='stats')


print 'saving netcdf..'
job.save_netcdf()

print 'done.'
