# -*- coding: utf-8 -*-
"""
title           : brdf_graph_polar.py
description     : script using the ADAM Toolkit demonstating making a polar BRDF graph
version         : 1.0
usage           : python brdf_graph.py
notes           :
"""



import numpy as np
import sys


# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')


# import the adam libraries
import adam
import adam_config


#my_path_data       = '/home/satellites9/cbacour/ADAM/Data/V1/'
#my_output_root_dir = '/home/satellites9/cbacour/ADAM/OUTPUT/'

# my_path_data       = 'p://3895-ADAM/code/data/'
# my_output_root_dir = 'Y://web-root/adam/web-output/'

# get an instance of an adam 'config' object, this will be attached to any jobs we run
#my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
my_config = adam_config.adam_config()


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = { 'fieldOperationType': 'brdf',
                 'fieldSpectralDomain': '850-850 nm',
                 'fieldBRType': 'polar',
                 'fieldSunZenith': 45,
                 'fieldViewZenith': 0,
                 'fieldRelAzimuth': 0,
                 'fieldMonth': 'jun',

                 'fieldCorner1Lat'   : 41.9,
                 'fieldCorner1Lon'   : 0.5,
                 'fieldCorner2Lat'   : 41.8,
                 'fieldCorner2Lon'   : 0.6
                 
                }

# initialise the job, providing us with a blank object ('job') to work with
print 'init job/config'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')


# now we are ready to load the data from our source database into our job object
print 'load data...'
job.load_data()

# print a little output to prove we know where we are in the world
print "%s land pixels, %s ocean pixels, %s snow pixels" % (len(job.data['idx_land']),
                                                           len(job.data['idx_ocean']),
                                                           len(job.data['idx_snow']))

# call the functions to populate the various variables
print 'perform reflectance calc...'
job.process_reflectance()


# define the phi and vza suitable for a polar plot..
job.phi = np.linspace(0,360, 41)
job.vza = np.linspace(0,65, 31)

print 'Perform BRDF calculation...'
# populates job.data['BRDF'] and job.data['BRDF_err_land']
job.process_brdf(do_spectral_averaging=True)

if job.is_pixel_request():
    job.graph_polar_plot(case='pixels', indices=job.data['idx_land'], title='Land Polar Graph', three_d=True)
    job.graph_polar_plot(case='pixels', indices=job.data['idx_snow'], title='Snow Polar Graph', three_d=True)
    job.graph_polar_plot(case='pixels', indices=job.data['idx_ocean'], title='Ocean Polar Graph', three_d=True)

    job.graph_polar_plot(case='pixels', indices=job.data['idx_land'], title='Land Polar Graph', three_d=False)
    job.graph_polar_plot(case='pixels', indices=job.data['idx_snow'], title='Snow Polar Graph', three_d=False)
    job.graph_polar_plot(case='pixels', indices=job.data['idx_ocean'], title='Ocean Polar Graph', three_d=False)
else:
    job.calculate_stats(job.data['BRDF'])
    job.graph_polar_plot(case='stats',  title='Stats Polar Graph', three_d=True)


job.save_netcdf()
print 'job output was written to: %s' % job.job_output_dir
