# -*- coding: utf-8 -*-
"""
title           : brdf_multidir_demo.py
description     : script using the ADAM Toolkit demonstrating taking making a BRDF
                  calculation.
notes           :
"""

import numpy as np
import sys


# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')


# import the adam libraries
import adam
import adam_config as adam_config


#my_path_data       = '/home/satellites9/cbacour/ADAM/Data/V1/'
#my_output_root_dir = '/home/satellites9/cbacour/ADAM/OUTPUT/'

# get an instance of an adam 'config' object, this will be attached to any jobs we run
#my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
print 'loading config...'
my_config = adam_config.adam_config()


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = { 'fieldOperationType': 'brdf',
                 'fieldSpectralDomain': '860-860 nm',
                 'fieldBRType': 'principal',
                 'fieldSunZenith': 0,
                 'fieldViewZenith': 0,
                 'fieldRelAzimuth': 0,
                 'fieldMonth': 'jan',

                 'fieldCorner1Lat'   : 20.3,
                 'fieldCorner1Lon'   : 0.4,
                 'fieldCorner2Lat'   : 20.,
                 'fieldCorner2Lon'   : 0

                }

# initialise the job, providing us with a blank object ('job') to work with
print 'initialise job...'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')


# now we are ready to load the data from our source database into our job object
print 'load data...'
job.load_data()

# print a little output to prove we know where we are in the world
print '- %s land pixels'  % len(job.data['idx_land'])
print '- %s ocean pixels' % len(job.data['idx_ocean'])
print '- %s snow pixels'  % len(job.data['idx_snow'])


# call the convenience functions to populate the various variables
print 'perform reflectance calc...'
job.process_reflectance()


# phi will be an array of integers from 30 to 60
job.phi = np.array(range(30, 60))

# vza will be a range with increased resolution around the hotspot
job.define_vza_hotspot()

print 'perform BRDF calc...'
job.process_brdf(do_spectral_averaging=True)
print 'saving netcdf BRDF calc...'
job.save_netcdf()

print 'done.'

#from matplotlib import pylab
#job.data['BRDF'].shape
# logitude, latitude, wavelength, vza, phi
#len(job.data['longitude'])
#len(job.data['latitude'])
#job.data['latitude']
#job.lmbd
#job.vza
#job.phi
#x = job.vza
#y = job.data['BRDF'][0,0,0,:,0].flatten()
#pylab.plot(x,y)
#pylab.show()





