# -*- coding: utf-8 -*-
"""
title           : spectrum_graph.py
description     : script using the ADAM Toolkit demonstating making a spectrum graph
version         : 1.0
usage           : python spectrum_graph.py
notes           :
"""


import sys

# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')


# import the main adam library
import adam

import adam_config

my_path_data       = '/home/satellites9/cbacour/ADAM/Data/FDS/Outputs/'
my_output_root_dir = '/home/satellites9/cbacour/ADAM/OUTPUT/'

#my_path_data       = 'p://3895-ADAM/code/data/'
#my_output_root_dir = 'Y://web-root/adam/web-output/'
# get an instance of an adam 'config' object, this will be attached to any jobs we run
#my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
#my_config = adam_config.adam_config()
my_config = adam_config.adam_config()
# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = {'fieldOperationType': 'spectrum',
                'fieldMonth'        : 'jan',
                'fieldSunZenith'    : 45,
                'fieldViewZenith'   : 0,
                'fieldRelAzimuth'   : 0,
                'fieldSpectralDomain': '400-1200 nm',

                 # ocean
                'fieldCorner1Lat'   : 43.6,
                'fieldCorner1Lon'   : -1.9,
                'fieldCorner2Lat'   : 44.1,
                'fieldCorner2Lon'   : -1.4

                # 'ieldCorner1Lon': '-1.9',
                # 'fieldCorner2Lon': '-1.4',
                # 'fieldSpectralDomain': '858-858',
                # 'fieldCorner2Lat': '44.1',
                # 'fieldCorner1Lat': '43.6',

                # snow with low reflectance values
                # 'fieldCorner1Lon': '47.2',
                # 'fieldCorner2Lon': '47.3',
                # 'fieldCorner2Lat': '52.9',
                # 'fieldCorner1Lat': '52.6'

                # land / ocean pixels
                # 'fieldCorner1Lat'   : 37.2,
                # 'fieldCorner1Lon'   : -3.7,
                # 'fieldCorner2Lat'   : 36.4,
                # 'fieldCorner2Lon'   : -2.9

                # snow flagged
                # 'fieldCorner1Lat'   : 76,
                # 'fieldCorner1Lon'   : -40.,
                # 'fieldCorner2Lat'   : 76.1,
                # 'fieldCorner2Lon'   : -40.2

                # 'fieldCorner1Lat'   : 37.1,
                # 'fieldCorner1Lon'   : -3.7,
                # 'fieldCorner2Lat'   : 37.3,
                # 'fieldCorner2Lon'   : -3.5

                # 'fieldCorner1Lon': '-4.1',
                # 'fieldCorner2Lon': '-2.6',
                # 'fieldCorner2Lat': '37.5',
                # 'fieldCorner1Lat': '36.8'

                # ocean only
                # 'fieldCorner1Lon': '-35',
                # 'fieldCorner2Lon': '-35.2',
                # 'fieldCorner2Lat': '28',
                # 'fieldCorner1Lat': '27.8'
                # 'fieldCorner1Lon': '-3.1',
                # 'fieldCorner2Lon': '-3.2',
                # 'fieldCorner2Lat': '44.2',
                # 'fieldCorner1Lat': '44.1'


                # snow with low reflectance values
                # 'fieldCorner1Lon': '47.2',
                # 'fieldCorner2Lon': '47.3',
                # 'fieldCorner2Lat': '52.9',
                # 'fieldCorner1Lat': '52.6'

# snow interface
                # 'fieldCorner1Lon': '44.9',
                # 'fieldCorner2Lon': '45',
                # 'fieldCorner2Lat': '50.2',
                # 'fieldCorner1Lat': '50.1'
                # snow with high reflectance values
                # 'fieldCorner1Lon': '-47.2',
                # 'fieldCorner2Lon': '-47.3',
                # 'fieldCorner2Lat': '66.9',
                # 'fieldCorner1Lat': '66.6'

                # Pyrenees
                # 'fieldCorner1Lon': '-0.4',
                # 'fieldCorner2Lon': '-0.3',
                # 'fieldCorner2Lat': '43.0',
                # 'fieldCorner1Lat': '42.7'

                }




# initialise the job, providing us with a blank object ('job') to work with
print 'initialise job..'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')

# now we are ready to load the data from our source database into our job object
print 'loading data..'
job.load_data()



# print a little output to prove we know where we are in the world
print "%s land pixels, %s ocean pixels, %s snow pixels" % (len(job.data['idx_land']),
                                                           len(job.data['idx_ocean']),
                                                           len(job.data['idx_snow']))


# call the convenience functions to populate the various variables
print 'calculate reflectance..'
# populates job.data['reflectance']
job.process_reflectance()

#job.spectral_domains = job.cfg.spectral_domains
print 'calculate brdf..'
job.process_brdf(do_spectral_averaging=False)


print 'make graphs..'
# now we can make our graphs

# graphs are created differently depending on how many pixels are to be rendered
# if there are only a few pixels we generate graphs depicting individual pixels
if job.is_pixel_request():
    print 'generating pixel graphs'
    # unlike ocean and snow, land spectrum graphs are treated one graph per pixel
    for i, pixel_index in enumerate(job.data['idx_land']):
        idx = [pixel_index]
        # the land error matrix is only populated for land pixels, so it uses a different counter
        job.graph_main_ref_spectra(case='pixels', indices=idx, title='Land pixel statistics')

    job.graph_main_ref_spectra(case='pixels', indices=job.data['idx_snow'],  title='Snow pixel statistics')
    job.graph_main_ref_spectra(case='pixels', indices=job.data['idx_ocean'], title='Ocean pixel statistics')
else:
    # or if there are many pixels we take the mean/max/min and graph only those stats
    print 'generating stats graphs'
    job.calculate_stats(job.data['BRDF'])
    job.graph_main_ref_spectra(case='stats')


print 'saving netcdf..'
job.save_netcdf()


# extra debugging
#from matplotlib import pylab
#import numpy as np
#
#pylab.plot(job.cfg.lmbd, np.transpose(job.data['reflectance'][0,:,:]))
#for i in range(len(job.data['idx_snow'])):
#    pylab.plot(job.cfg.modis_wavebands, job.data['ref_land'][0,i],'o')
#pylab.show()


print 'done.'

