# -*- coding: utf-8 -*-
"""
title           : brdf_graph.py
description     : script using the ADAM Toolkit demonstating making making BRDF graphs
version         : 1.0
usage           : python brdf_graph.py
notes           :
"""



import sys


# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')


# import the adam libraries
import adam
import adam_config


# my_path_data       = 'p://3895-ADAM/code/data/'
# my_output_root_dir = 'Y://web-root/adam/web-output/'
my_path_data       = '/home/satellites9/cbacour/ADAM/Data/FDS/Outputs/'
my_output_root_dir = '/home/scratch01/cbacour/ADAM/'


# get an instance of an adam 'config' object, this will be attached to any jobs we run
my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
#my_config = adam_config.adam_config()


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = { 'fieldOperationType': 'brdf',
                 'fieldSpectralDomain': '850-860 nm',
                 'fieldBRDFType': 'plane',
                 'fieldSunZenith': 45,
                 'fieldViewZenith': 40,
                 'fieldRelAzimuth': 0,
                 'fieldMonth': 'jan',
                 'fieldComputeError': False,

                # snow with low reflectance values
#                 'fieldLatMin'   : 63.2,
#                 'fieldLonMin'   : 27.2,
#                 'fieldLatMax'   : 63.3,
#                 'fieldLonMax'   : 27.4

                 # 'fieldLatMin'   : 43.2,
                 # 'fieldLonMin'   : 0.5,
                 # 'fieldLatMax'   : 43,
                 # 'fieldLonMax'   : 0.6

                 # 'fieldNetCDF_main' : 'ADAM_netcdf_M01_Lon_3.25_8.85_Lat_21.65_25.25.nc',
                 # 'fieldNetCDF_covarland' : 'ADAM_netcdf_M01_Lon_3.25_8.85_Lat_21.65_25.25.nc',

                 # 'fieldLatMin'   : 23.,
                 # 'fieldLonMin'   : 4.,
                 # 'fieldLatMax'   : 23.5,
                 # 'fieldLonMax'   : 4.2

                 'fieldLatMin'   : 23.,
                 'fieldLonMin'   : 4.1,
                 'fieldLatMax'   : 23.15,
                 'fieldLonMax'   : 4.2


                #  # land + ocean
                # 'fieldLatMin'   : 37.2,
                # 'fieldLonMin'   : -3.7,
                # 'fieldLatMax'   : 36.4,
                # 'fieldLonMax'   : -2.9

                 # snow with high reflectance values
                # 'fieldLonMin': '-47.2',
                # 'fieldLonMax': '-47.3',
                # 'fieldLatMax': '66.9',
                # 'fieldLatMin': '66.6'
                }

# initialise the job, providing us with a blank object ('job') to work with
print 'init job/config'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')

# now we are ready to load the data from our source database into our job object
print 'load data...'
job.load_data()

# print a little output to prove we know where we are in the world
print "%s land pixels, %s ocean pixels, %s snow pixels" % (len(job.data['idx_land']),
                                                           len(job.data['idx_ocean']),
                                                           len(job.data['idx_snow']))

# call the convenience functions to populate the various variables
print 'perform reflectance calc...'
job.process_reflectance()

# Increase vza sampling depending on sza (increase resolution near sza)
print 'define_vza_hotspot...'
job.define_vza_hotspot()

print 'Perform BRDF calculation...'
# populates job.data['BRDF'] and job.data['BRDF_err_land']
job.process_brdf(do_spectral_averaging=True)



# graphs are created differently depending on how many pixels are to be rendered
# if there are only a few pixels we generate graphs depicting individual pixels
if job.is_pixel_request():
    print 'generating pixel graphs'
    job.graph_transect_plane(case='pixels', indices=job.data['idx_land'],  title='BRDF Land pixel statistics', graph_error=True)
    job.graph_transect_plane(case='pixels', indices=job.data['idx_ocean'], title='BRDF Ocean pixel statistics')
    job.graph_transect_plane(case='pixels', indices=job.data['idx_snow'],  title='BRDF Snow pixel statistics' )



else:
    # or if there are many pixels we take the mean/max/min and graph only those stats
    print 'generating stats graphs'
    job.calculate_stats(job.data['BRDF'])
    job.graph_transect_plane(case = 'stats')



job.save_netcdf()
print 'job output was written to: %s' % job.job_output_dir
