# -*- coding: utf-8 -*-
"""
title           : brdf_graph_time_series.py
description     : script using the ADAM Toolkit demonstating making making BRDF time series graphs
version         : 1.0
usage           : python brdf_graph_time_series.py
notes           :
"""



import sys

# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')

# import the main adam library
import adam
import adam_config as adam_config


my_output_root_dir = '/home/scratch01/cbacour/ADAM/'
my_path_data       = '/home/satellites9/cbacour/ADAM/Data/FDS/Outputs/'

# get an instance of an adam 'config' object, this will be attached to any jobs we run
my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
#my_config = adam_config.adam_config()


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = {
    'fieldOperationType': 'brdf-time',
    'fieldSpectralDomain': '858-858 nm',
    'fieldBRDFType': 'plane',
    'fieldSunZenith': 45,
    'fieldViewZenith': 0,
    'fieldRelAzimuth': 0,

    'fieldLatMin'   : 44.1,
    'fieldLonMin'   : -1.9,
    'fieldLatMax'   : 43.6,
    'fieldLonMax'   : -1.4
}




# initialise the job, providing us with a blank object ('job') to work with
print 'initialise job..'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')


print 'make time series'
job.graph_brdf_time()

# data is available in: job.data['stats']['land']['mean']
print 'job output was written to: %s' % job.job_output_dir


















