# -*- coding: utf-8 -*-
#!/usr/bin/env python
"""
title           : make_colourbars.py
description     : script to build colour bars for the ADAM website from the known 
                  reflectance ranges of each waveband
date            : Thu Feb 28 10:45:08 2013
version         : 0.1
usage           : python make_colourbars.py
notes           :


"""




import numpy as np
import sys
import os
import tempfile
import matplotlib
from matplotlib import cm
import matplotlib.pyplot as pyplot


# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')

# import the main adam library
import adam
import adam_config as adam_config

my_config = adam_config.adam_config()

# spectral domains to make the colourbars for, these come from the make_map.py script.
# we will expect to find the min/max ranges in the adam config for each of these.
SPECTRAL_DOMAINS = [(300, 400), (400, 700), (700, 1300), (1300, 2500), (2500, 4000),
                    (469,469), (555,555), (645,645), (858,858), (1240,1240), (1640,1640), (2130, 2130)]

# width and height in pixels
FIG_WIDTH, FIG_HEIGHT = 120, 550
COLOURBAR_TITLE = 'title'
 
 
# get the reflectance ranges for each band from the adam config
reflectance_limits = my_config.reflectance_limits

for i,domain in enumerate(SPECTRAL_DOMAINS):
    limits = reflectance_limits[domain]
    land_min = limits['land']['min']
    land_max = limits['land']['max']
    ocean_min = limits['ocean']['min']
    ocean_max = limits['ocean']['max']


    land_bounds = np.linspace(land_min, land_max, 50)
    land_max_rounded = round(land_max * 10)/10.
    land_ticks = np.linspace(0, land_max_rounded, land_max_rounded*10 + 1)
    land_cmap = cm.get_cmap('jet')

    # some hacky code to get the tickmarks looking ok for ocean values
    divisor = 1/ocean_max
    factor = 10000.
    if divisor<2000: factor=1000.
    if divisor<100: factor=100.
    if divisor<40: factor=200.
    ocean_bounds = np.linspace(ocean_min, ocean_max, 50)
    ocean_max_rounded = round(ocean_max * factor)/factor
    ocean_ticks = np.arange(0,ocean_max_rounded+ 1/factor,1/factor)

    ocean_cmap = cm.get_cmap('gist_earth')
    
    fig = pyplot.figure(figsize=(FIG_WIDTH/100., FIG_HEIGHT/100.))
    ax2 = fig.add_axes([0.1, 0.02, 0.20, 0.45])
    ax1 = fig.add_axes([0.1, 0.52, 0.20, 0.45])
    
    norm = matplotlib.colors.BoundaryNorm(land_bounds, land_cmap.N)
    cb1 = matplotlib.colorbar.ColorbarBase(ax1, cmap=land_cmap,
                                         norm=norm,
                                         boundaries=land_bounds,
                                         ticks=land_ticks, # optional
                                         spacing='proportional',
                                         orientation='vertical')
    pyplot.setp(ax1.get_yticklabels(),  fontsize=8)
    cb1.set_label('\nLand', fontsize=10)

    
    
    norm = matplotlib.colors.BoundaryNorm(ocean_bounds, ocean_cmap.N)
    cb2 = matplotlib.colorbar.ColorbarBase(ax2, cmap=ocean_cmap,
                                         norm=norm,
                                         boundaries=ocean_bounds,
                                         ticks=ocean_ticks, # optional
                                         spacing='proportional',
                                         orientation='vertical')

    pyplot.setp(ax2.get_yticklabels(),  fontsize=8)
    cb2.set_label('\nOcean', fontsize=10)






















    filename = 'e://adam-colourbar-%s.png' % i
    pyplot.savefig(filename, dpi=100)
    

