# -*- coding: utf-8 -*-
"""
title           : spectrum_graph.py
description     : script using the ADAM Toolkit demonstating making a spectrum graph
version         : 1.0
usage           : python spectrum_graph.py
notes           :
"""


import sys

# this script may live in the test/ directory and the adam class my not be in the PATH,
# so we add this here to allow for that case
if not '../' in sys.path:
    sys.path.insert(0, '../')


# import the main adam library
import adam

import adam_config


my_output_root_dir = '/home/scratch01/cbacour/ADAM/'
my_path_data       = '/home/satellites9/cbacour/ADAM/Data/FDS/Outputs/'


# get an instance of an adam 'config' object, this will be attached to any jobs we run
my_config = adam_config.adam_config(path_data = my_path_data, output_root_dir = my_output_root_dir)
#my_config = adam_config.adam_config()


# define the type of adam calculation we wish to perform..
# NOTE that you can build a request like this using the web site and copy / paste
# the 'request_dictionary' from the logfile into this script
request_dict = {'fieldOperationType' : 'spectrum',
                'fieldMonth'         : 'jan',
                'fieldSunZenith'     : 45,
                'fieldViewZenith'    : 0,
                'fieldRelAzimuth'    : 0,
                'fieldSpectralDomain': '400-1200 nm',
                'fieldInstrument'    : 'landsat_7',
                'fieldComputeError': False,
                # snow with low reflectance values
                # 'fieldLonMin': '47.2',
                # 'fieldLonMax': '47.3',
                # 'fieldLatMax': '52.9',
                # 'fieldLatMin': '52.6'

                # land / ocean pixels
                #'fieldLatMin'   : 37.2,
                # 'fieldLonMin'   : -3.7,
                # 'fieldLatMax'   : 36.4,
                # 'fieldLonMax'   : -2.9
                'fieldNetCDF_main' : 'ADAM_netcdf_M01_Lon_3.25_8.85_Lat_21.65_25.25.nc',
                'fieldNetCDF_covarland' : 'ADAM_netcdf_M01_Lon_3.25_8.85_Lat_21.65_25.25.nc',

                'fieldLatMin'   : 23.,
                'fieldLonMin'   : 4.1,
                'fieldLatMax'   : 23.15,
                'fieldLonMax'   : 4.2
                
                # snow flagged
                 # 'fieldLatMin'   : 76,
                 # 'fieldLonMin'   : -40.,
                 # 'fieldLatMax'   : 76.1,
                 # 'fieldLonMax'   : -40.2

                }




# initialise the job, providing us with a blank object ('job') to work with
print 'initialise job..'
job = adam.adam_job( cfg=my_config )

# now validate our request against certain logic rules, and populate any unpopulated required fields
# with default values
if not job.validate_input(request_dict):
    raise Exception('request input invalid !')

# now we are ready to load the data from our source database into our job object
print 'loading data..'
job.load_data()



# print a little output to prove we know where we are in the world
print "%s land pixels, %s ocean pixels, %s snow pixels" % (len(job.data['idx_land']),
                                                           len(job.data['idx_ocean']),
                                                           len(job.data['idx_snow']))


# call the convenience functions to populate the various variables
print 'calculate reflectance..'

# populates job.data['reflectance']
job.process_reflectance()

#job.spectral_domains = job.cfg.spectral_domains
print 'calculate brdf..'
job.process_brdf(do_spectral_averaging=False)

# now we can make our graphs
print 'make graphs..'

# graphs are created differently depending on how many pixels are to be rendered
# if there are only a few pixels we generate graphs depicting individual pixels
if job.is_pixel_request():
    print 'generating pixel graphs'
    # unlike ocean and snow, land spectrum graphs are treated one graph per pixel
    for i, pixel_index in enumerate(job.data['idx_land']):
        idx = [pixel_index]
        # the land error matrix is only populated for land pixels, so it uses a different counter
        job.graph_main_ref_spectra(case='pixels', indices=idx, title='Land pixel statistics')

    job.graph_main_ref_spectra(case='pixels', indices=job.data['idx_snow'],  title='Snow pixel statistics')
    job.graph_main_ref_spectra(case='pixels', indices=job.data['idx_ocean'], title='Ocean pixel statistics')
else:
    # or if there are many pixels we take the mean/max/min and graph only those stats
    print 'generating stats graphs'
    job.calculate_stats(job.data['BRDF'])
    job.graph_main_ref_spectra(case='stats')


print 'saving netcdf..'
job.save_netcdf()

print 'done.'

