from peak.util.addons import AddOn
from types import ClassType

from declarations import *
from queries import *
from composition import Break, Nop
from walls import AdaptationWall


class AdaptationFailure(TypeError):
    pass

def adapt(ob, proto, default=AdaptationFailure):
    if isinstance(proto, (type, ClassType)) and isinstance(ob, proto):
        return ob
    for adapter in adapters_for_object(ob, proto):
        result = adapter.adapt(ob)
        if result is not None:
            return result
    if default is not AdaptationFailure:
        return default
    else:
        raise AdaptationFailure("Cant adapt:", ob, proto)

class ProtocolBase(object):
    def __call__(self, ob, default=AdaptationFailure):
        return adapt(ob, self, default)


class Protocol(ProtocolBase):
    class __metaclass__(type):
        registry = {}
        def __call__(cls, key=None, **kw):
            ob = cls.registry.get((cls, key))
            if ob is not None:
                return ob
            else:
                return type.__call__(cls, key, **kw)

    def __init__(self, key, repr_name=None):
        if key is not None:
            cls = type(self)
            cls.registry[(cls, key)] = self
        self.key = key
        self.repr_name = repr_name

    def __repr__(self):
        if self.repr_name is not None:
            #@@@@@@ module name
            return self.repr_name
        else:
            return type(self).__name__ + repr((self.key,))


class Interface(type):
    #@@@@@
    #class __metaclass__(type):
    #    def __init__(cls, name, bases, dct):
    #        declare_adapter(cls, bases)

    def __new__(self, ob, default=AdaptationFailure):
        return adapt(ob, self, default)

declare_adapter([list, tuple], iter)

class sequence_of(ProtocolBase, AddOn):
    def __init__(self, proto):
        declare_adapter(self, iter)
        declare_adapter(iter, self, lambda ob: map(proto, ob))
