from peak.util.decorators import decorate_class

from registries import AdapterRegistry, addons_for, object_provides
from composition import make_adapter
from types import ClassType


__all__ = [ 'advise_object',
            'implements',
            'adapts', 'always_adapts', 'check_provides',
            'declare_adapter', 'declare_protocol_identity']

basetypes = set([str, unicode,
                bool, int, float,
                dict, list, tuple])


def advise_object(ob, protocols):
    object_provides(ob, True).update(asiter(protocols))

def declare_adapter(from_, to, adapt_func=None, conditional=True, cost=1):
    adapter = make_adapter(adapt_func, conditional, cost)
    for to_item in asiter(to):
        for from_item in asiter(from_):
            AdapterRegistry(to_item).add_adapter(from_item, adapter)

def adapts(from_, to=None, **kw):
    if to is None:
        def decorator(cls):
            declare_adapter(from_, cls, cls, False, **kw)
            return cls
        decorate_class(decorator)
    else:
        def decorator(func):
            declare_adapter(from_, to, func, **kw)
            return func
        return decorator

def always_adapts(from_, to, cost=1):
    def decorator(func):
        declare_adapter(from_, to, func, False, cost)
        return func
    return decorator

def check_provides(from_, to, check=None, cost=1):
    def decorator(func):
        def adapter(ob):
            if func(ob):
                advise_object(ob, to)
                return ob
        adapter.func_name = 'check_adapt<%s>' % func.func_name
        declare_adapter(from_, to, adapter, True, cost)
        return func
    if check is None:
        return decorator
    else:
        decorator(check)


def implements(protocol):
    def decorator(cls):
        declare_adapter(cls, protocol)
        return cls
    decorate_class(decorator)


def advise_registry(proto, registry):
    addons = addons_for(proto)
    if AdapterRegistry in addons:
        raise ValueError(proto, AdapterRegistry(proto), registry)
    addons[AdapterRegistry] = registry

def declare_protocol_identity(proto, subst):
    advise_registry(proto, AdapterRegistry(subst))


def asiter(ob):
    if isinstance(ob, (list, tuple, set, frozenset)):
        return ob
    else:
        return [ob]



