from registries import object_provides, AdapterRegistry


def adapters_for_object(ob, proto):
    provided = object_provides(ob)
    return adapters_for_protocols(provided, proto)

def adapters_for_protocols(from_protocols, to):
    return AdapterRegistry(to).sorted_adapters_from(from_protocols)

def adapter_for_protocol(from_protocol, to):
    return AdapterRegistry(to).adapter_from(from_protocol)
