from __future__ import with_statement
from threading import RLock
from weakref import WeakKeyDictionary, ref
from types import ClassType, InstanceType, BuiltinFunctionType

from peak.util.addons import AddOn, addons_for
#from peak.rules import *

from composition import Nop, chain, overload

NOP_base = Nop(5)
NOP_self = Nop(0)

def object_provides(ob, create=False):
    try:
        return ob.__dict__[object_provides]
    except (KeyError, AttributeError):
        #@@@@@@
        cls = type(ob)
        if cls is InstanceType:
            cls = ob.__class__
        AdapterRegistry(cls)
        provides = [cls, object]

        if create:
            return ob.__dict__.setdefault(object_provides, set(provides))
        else:
            return provides


class MyWeakKeyDictionary(WeakKeyDictionary):
    def __setitem__(self, key, value):
        if not isinstance(key, (ClassType, BuiltinFunctionType)):
            key = ref(key, self._remove)
        self.data[key] = value

    def get(self, key, default=None):
        if not isinstance(key, (ClassType, BuiltinFunctionType)):
            key = ref(key)
        return self.data.get(key, default)

    def iteritems(self):
        for key, value in self.data.iteritems():
            if isinstance(key, ref):
                key = key()
                if key is None:
                    continue
            yield key, value




class AdapterRegistry(object):
    class __metaclass__(type):
        builtin_addons = {}
        def __call__(cls, proto):
            if isinstance(proto, BuiltinFunctionType):
                a = cls.builtin_addons.setdefault(proto, {})
            else:
                a = addons_for(proto)
            try:
                return a[AdapterRegistry]
            except KeyError:
                registry = a.setdefault(AdapterRegistry, type.__call__(cls, proto))
                if isinstance(proto, type):
                    for base in proto.__bases__:
                        AdapterRegistry(base).add_adapter(proto, NOP_base)
                return registry

    def __init__(self, proto):
        self.proto = proto
        self.lock = RLock()
        self.incoming_adapters = MyWeakKeyDictionary()
        self.incoming_subscribers = MyWeakKeyDictionary()
        self.outgoing_subscribers = MyWeakKeyDictionary()

    def __repr__(self):
        return type(self).__name__ + repr((self.proto,))

    def sorted_adapters_from(self, from_protocols):
        adapters = map(self.adapter_from, from_protocols)
        adapters = [a for a in adapters if a is not None]
        adapters.sort(key=lambda adapter: adapter.cost)
        return adapters

    def adapter_from(self, proto):
        #proto = asprotocol(proto)
        if proto is self.proto:
            return NOP_self
        else:
            return self.incoming_adapters.get(proto)


    def add_adapter(self, proto, adapter, subscribe=True):
        if proto is self.proto:
            return
        with self.lock:
            old_adapter = self.incoming_adapters.get(proto)
            if old_adapter is not None:
                #print `(old_adapter.depth, adapter.depth)`, proto, '=>', self.proto #@@x
                adapter = overload(adapter, old_adapter)
                if adapter == old_adapter:
                    return
            #@@
            #print  '!', proto, '\t=(%d)=>' % adapter.cost, self.proto
            #print '\t', adapter, old_adapter

            self.incoming_adapters[proto] = adapter
            if subscribe:
                self.incoming_subscribers[proto] = adapter

            AdapterRegistry(proto).process_adapter(self, adapter, subscribe)
            self.notify_subscribers(proto, adapter)

    def notify_subscribers(self, proto, adapter):
        for outproto, outadapter in self.outgoing_subscribers.iteritems():
            outregistry = AdapterRegistry(outproto)
            with outregistry.lock:
                outadapter_c = chain(adapter, outadapter)
                outregistry.add_adapter(proto, outadapter_c, False)

    def process_adapter(self, to, ext, subscribe):
        with self.lock:
            if subscribe:
                self.outgoing_subscribers[to.proto] = ext
            #print 'process_adapter', repr((self, to, ext, subscribe))
            #for inproto, inadapter in sorted(self.incoming_subscribers.items(), key=lambda (p,a): a.cost):
            for proto, adapter in self.incoming_subscribers.iteritems():
                adapter = chain(adapter, ext)
                to.add_adapter(proto, adapter, False)






