from types import *
from declarations import advise_registry, basetypes

class AdaptationWall(object):
    debug = False
    def __init__(self, proto):
        self.proto = proto

    def add_adapter(self, proto, adapter, subscribe=True):
        if self.debug:
            print 'WALL.add_adapter%s' % repr(args)
        if subscribe and not issubclass(proto, self.proto):
            raise TypeError("Can't add adapter from %r to %r" % (proto, self.proto))

    @classmethod
    def process_adapter(cls, *args):
        if cls.debug:
            print 'WALL.process_adapter%s' % repr(args)


for proto in [  object, NoneType,
                type, ClassType,
                MethodType, FunctionType] + list(basetypes):
    advise_registry(proto, AdaptationWall(proto))
