from types import *
from peak.util.addons import AddOn
from signature import Signature

class Annotation(AddOn):
    ismethod = True
    def __init__(self, ob):
        self.ob = ob
        if isinstance(ob, FunctionType):
            self.func = ob
            self.ismethod = False
        elif isinstance(ob, MethodType):
            self.func = ob.im_func
        elif isinstance(ob, (type, ClassType)):
            self.func = ob.__init__.im_func
        elif callable(ob):
            self.func = ob.__call__.im_func
        else:
            raise TypeError("Can't annotate: %r is not callable" % ob)
        self.signature = Signature(self.func)

    def declare_accepts(self, accepts):
        accepts = list(accepts)
        if self.ismethod:
            accepts.insert(0, None)
        self.signature.accepts = accepts
        self.recompile()

    def declare_returns(self, returns):
        self.signature.returns = returns
        self.recompile()

    def recompile(self):
        self.func.func_code = self.signature.compile_wrapped()
