from annotation import Annotation

def declare_accepts(ob, accepts):
    if not isinstance(accepts, (list, tuple)):
        accepts = [accepts]
    Annotation(ob).declare_accepts(accepts)

def declare_returns(ob, proto):
    Annotation(ob).declare_returns(proto)

def accepts(*protocols):
    def decorate(func):
        declare_accepts(func, protocols)
        return func
    return decorate

def returns(proto):
    def decorate(func):
        declare_returns(func, proto)
        return func
    return decorate
