import new
import inspect

from peak.util.assembler import *
from peak.util.addons import AddOn

from adaptation import adapt
from adaptation.api.declarations import basetypes


class Signature(AddOn):
    def __init__(self, func):
        self.original_func = new.function(func.func_code, func.func_globals, func.func_name)
        self.args, self.var, self.kw = inspect.getargs(func.func_code)

    __accepts = ()

    def _get_accepts(self):
        return self.__accepts

    def _set_accepts(self, accepts):
        accepts = tuple(accepts)
        if self.accepts and self.accepts != accepts:
            raise ValueError("Can't override `accepts`", self.accepts, accepts)
        self.__accepts = accepts

    accepts = property(_get_accepts, _set_accepts)

    __returns = None

    def _get_returns(self):
        return self.__returns

    def _set_returns(self, returns):
        if self.returns is not None and self.returns != returns:
            raise ValueError("Can't override `returns`", self.returns, returns)
        self.__returns = returns

    returns = property(_get_returns, _set_returns)

    def compile_wrapped(self):
        if len(self.args) < len(self.accepts):
            raise ValueError("Signature is longer than the argument list")

        c = Code.from_function(self.original_func)
        c.LOAD_CONST(self.original_func)

        for arg, proto in zip(self.args, self.accepts):
            ADAPT(c, arg, proto)
        map(c.LOAD_FAST, self.args[len(self.accepts):])

        CALL(c, self)

        if self.returns is not None:
            c.STORE_FAST('result')
            ADAPT(c, 'result', self.returns)

        c.RETURN_VALUE()

        return c.code()



def CALL(c, ann):
    CALL = c.CALL_FUNCTION
    if ann.var:
        c.LOAD_FAST(ann.var)
        CALL = c.CALL_FUNCTION_VAR
    if ann.kw:
        c.LOAD_FAST(ann.kw)
        CALL = c.CALL_FUNCTION_KW
    if ann.var and ann.kw:
        CALL = c.CALL_FUNCTION_VAR_KW
    CALL(len(ann.args))


def ADAPT(c, name, protocol):
    if protocol in [object, None]:
        c.LOAD_FAST(name)
    elif protocol in basetypes:
        c.LOAD_CONST(protocol)
        c.LOAD_FAST(name)
        c.CALL_FUNCTION(1)
    elif isinstance(protocol, tuple):
        c.LOAD_CONST(isinstance)
        c.LOAD_FAST(name)
        c.LOAD_CONST(protocol)
        c.CALL_FUNCTION(2)
        skip = c.JUMP_IF_TRUE()
        c.LOAD_CONST(TypeError)
        c.LOAD_CONST("Wrong type for `%s`:" % name)
        c.LOAD_FAST(name)
        c.LOAD_CONST(protocol)
        c.CALL_FUNCTION(3)
        c.RAISE_VARARGS(1)
        skip()
        c.POP_TOP()
        c.LOAD_FAST(name)
    else:
        c.LOAD_CONST(adapt)
        c.LOAD_FAST(name)
        c.LOAD_CONST(protocol)
        c.CALL_FUNCTION(2)

