from lxml.html import fragments_fromstring, tostring
from mimetype import *

class TracWikiData(MimeTypedData):
    def as_html(self):
        html = unicode(format_to_html(env, default_context, unicode(self)))
        fragments = fragments_fromstring(html.replace('\r', ''))
        for frag in fragments:
            map(clean_wiki_anchor, frag.findall('.//a'))
        return MimeType.HTML('\n'.join(map(tostring, fragments)))


MimeType.register_constant('TRAC_WIKI', 'text/x-trac-wiki')
MimeType.TRAC_WIKI.register_implementation(TracWikiData)

##################################################################
##################################################################


def clean_wiki_anchor(a):
    if 'missing' in get_classes(a) and a.text.endswith('?'):
        a.text = a.text[:-1]
    clean_href(a)
    keep_attrs(a, ['href'])
    #clean_classes(a, 'missing')
    #remove_attrs(a, ['rel', 'class'])


def clean_href(a):
    href = a.get('href')
    if href and href.startswith('./'):
        a.set('href', href[2:])
    if href and href.startswith('./wiki/'):
        a.set('href', href[6:])



def remove_attrs(elem, attrs):
    for attr in attrs:
        del elem.attrib[attr]

def keep_attrs(elem, attrs):
    for attr in elem.keys():
        if attr not in attrs:
            del elem.attrib[attr]



def get_classes(elem):
    return set(elem.get('class', '').split())

def clean_classes(elem, *remove_classes):
    classes = get_classes(elem)
    if classes:
        classes.difference_update(remove_classes)
        if classes:
            elem.set('class', ' '.join(classes))
        else:
            remove_attrs(elem, ['class'])


##################################################################
##################################################################

from trac.test import EnvironmentStub
from trac.web.href import Href
from trac.mimeview import Context
from trac.test import Mock, MockPerm
from trac.wiki.formatter import format_to_html


env = EnvironmentStub()
env.config['wiki'].set('ignore_missing_pages', 'true')

def TracReq(base):
    return Mock( href=Mock(wiki=Href(base)),
                abs_href=Href(base),
                perm=MockPerm())

default_context = Context.from_request(TracReq('.'))
default_context.href = Href('.')


if __name__ == '__main__':
    text = TracWikiData(u'== foo ==')
    #print text.as_html()
    print TracWikiData('--').as_html()
