from types import MethodType, FunctionType, NoneType
from inspect import getargspec

from wsgi import *


try:
    from webob.exc import HTTPNotFound
    not_found = HTTPNotFound()
    declare_adapter(NoneType, HTTPNotFound,
                    lambda none: not_found,
                    conditional=False)


except ImportError:
    def not_found(environ, start_response):
        start_response('404 Not Found', [])
        return "Error 404: Not Found"

    advise_object(not_found, WSGI)
    declare_adapter(NoneType, WSGI,
                    lambda none: not_found,
                    conditional=False)


def asfunc(ob):
    if not isinstance(ob, MethodType) and hasattr(ob, '__call__'):
        return ob.__call__

@check_provides(object, WSGI)
def check_object(ob):
    call = asfunc(ob)
    if call is None:
        return False
    elif WSGI(call, None) is call:
        #declare_wsgi_class(ob.__class__)
        declare_adapter(ob.__class__, WSGI)
        return True


#@@@@@@@@ disabled due to a WALL / object-provides
@check_provides([FunctionType, MethodType], WSGI)
def check_function(func):
    args = getargspec(func)[0]
    if hasattr(func, 'im_self'):
        args.pop(0)
    if args == ['environ', 'start_response']:
        advise_object(func, WSGI)
        return True


