from adaptation.wsgi.wsgi import *
from adaptation.funcs import *
#from adaptation.transform_arg import *

from paste import urlmap, fileapp, session, cascade, recursive, gzipper, \
                    errordocument, httpexceptions,\
                    httpserver
from paste.exceptions import errormiddleware
from paste.evalexception.middleware import EvalException
#from paste.debug import profile


declare_accepts(httpserver.serve, WSGI)

for middleware in [ session.SessionMiddleware,
                    recursive.RecursiveMiddleware,
                    gzipper.middleware,
                    errormiddleware.ErrorMiddleware,
                    errordocument.StatusBasedForward,
                    #profile.ProfileMiddleware,
                    EvalException,
                ]:
    declare_accepts(middleware, WSGI)
    declare_wsgi_class(middleware)

declare_accepts(urlmap.URLMap.__setitem__, ((str, unicode, tuple), WSGI))
declare_accepts(cascade.Cascade, sequence_of(WSGI))

map(declare_wsgi_class, [   urlmap.URLMap,
                            fileapp.FileApp,
                            fileapp.DataApp,
                            fileapp.ArchiveStore,
                            cascade.Cascade,
                            httpexceptions.HTTPException,
                        ])

