import urllib
from webob import Request, Response
from webob.exc import HTTPException

from adaptation.wsgi.wsgi import *
from adaptation.mime import *

declare_wsgi_class(Response)
declare_wsgi_class(HTTPException)

@always_adapts([urllib.addinfo, urllib.addinfourl], Response)
def read_urllib(stream):
    if Response not in stream.__dict__:
        stream.__dict__[Response] = Response(stream.read(), headers=stream.info())
    return stream.__dict__[Response]

@always_adapts([Request, Response], MimeTypedData)
def read_request(ob):
    return MimeTypedData(ob.body, ob.content_type, ob.charset)

@always_adapts(MimeTypedData, Response)
def write_response(data):
    return Response(body=data, content_type=str(data.mimetype), charset=data.charset)

from adaptation import *
declare_adapter(Request, Response, Break)
