from xml.etree.ElementTree import ElementTree, Element, parse, tostring, XML
from cStringIO import *

from adaptation import *
from adaptation.mime import *

try:
    from xml.etree.cElementTree import ElementTree as cElementTree, Element, parse, tostring, XML
    declare_protocol_identity(cElementTree, ElementTree)
except ImportError:
    pass



@always_adapts(ElementTree, MimeTypedData)
def dump_etree(tree, charset='UTF-8'):
    stream = StringIO()
    tree.write(stream, charset)
    return MimeType.XML(stream.getvalue(), charset=charset)


if __name__ == '__main__':
    from types import BuiltinFunctionType
    from adaptation.api import *
    from xml.etree.cElementTree import Element

    e = Element('FOO')
    tree = ElementTree(e)
    print type(e), type(tree)
    assert tree.__class__ is ElementTree
    data = MimeType.XML(tree)
    print data
    print adapt(data, ElementTree)

    #import urllib_support
    from urllib import urlopen
    s = urlopen('http://maluke.com/')
    text = MimeType.TEXT(s)
    print text.mimetype, text.charset
    print unicode(text)[:40]
    print adapt(s, ElementTree)
