from cStringIO import *
from lxml.html import HtmlElement, document_fromstring, tostring

from adaptation import *
from adaptation.mime import *


@always_adapts(HtmlElement, MimeTypedData)
def dump_element(elem, charset='UTF-8'):
    return MimeType.HTML(tostring(elem, charset), charset=charset)

#@adapts(MimeType.HTML, HtmlElement, guaranteed=True)
#def parse_mimedata(data):
#    return document_fromstring(data)

declare_adapter(MimeType.HTML, HtmlElement, document_fromstring, conditional=False)



if __name__ == '__main__':
    from types import BuiltinFunctionType
    from adaptation.api import *

    tree = document_fromstring('foo<br>')
    assert tree.__class__ is HtmlElement
    data = MimeType.HTML(tree)
    print data, data.mimetype
    print adapt(data, HtmlElement)

    from urllib import urlopen
    s = urlopen('http://maluke.com/')
    #text = MimeType.TEXT(s)
    text = MimeType.HTML(s)
    print text.mimetype, text.charset
    print unicode(text)[:40]
    doc = adapt(s, HtmlElement)
    print doc

    from lxml.html import open_in_browser
    open_in_browser(doc)
