from adaptation import *
from adaptation.mime import *

from xmlgen import XmlDocument
from htmlgen import HtmlDocument

@always_adapts(XmlDocument, MimeTypedData)
def xml_data(xmldoc):
    return MimeType.XML(str(xmldoc), charset=xmldoc.encoding)

@always_adapts(HtmlDocument, MimeTypedData)
def html_data(htmldoc):
    return MimeType.HTML(str(htmldoc), charset=htmldoc.encoding)

if __name__ == '__main__':
    #import webob_support
    from adaptation.wsgi import WSGI
    from webob import Response
    doc = HtmlDocument('foo')
    html = MimeType.HTML(doc)
    #print html
    #print adapt(html, Response)
    print WSGI(html)
    print WSGI(doc)
