from adaptation.funcs import *
from nose.tools import *

def f10(x, y='foo', *args):
    return 10 * x, y, args

@accepts((int, float))
def num(x):
    return x

@accepts(int, int)
@returns(str)
def add(a, b):
    return a + b

def test_f10():
    assert f10('1', '!', '?') == ('1111111111', '!', ('?',))

    declare_accepts(f10, int)

    assert f10('1') == (10, 'foo', ())
    assert f10(y='x', x=2) == (20, 'x', ())
    assert f10(3.0, '!') == (30, '!', ())
    assert f10(4.1, '!', '?') == (40, '!', ('?',))

def test_num():
    assert num(1.0) == 1.0
    assert_raises(TypeError, num, '1.0')

def test_returns():
    assert add('1', '2') == '3'

if __name__ == '__main__':
    import nose
    nose.main()
