from adaptation import *

class IFoo(Interface):
    pass

class IFoo2(IFoo):
    pass

class Foo(object):
    implements(IFoo)


def test_foo():
    foo = Foo()
    assert IFoo(foo) is foo
    assert IFoo2(foo, None) is None

def test_subfoo():
    class SubFoo(Foo):
        pass

    subfoo = SubFoo()
    assert IFoo(subfoo) is subfoo

    class Foo2(object):
        implements(IFoo2)

    foo2 = Foo2()
    assert IFoo(foo2) is foo2
    assert IFoo2(foo2) is foo2


def test_foobar():
    class IBar(Interface):
        pass

    class FooBar(object):
        implements(IBar)
        adapts(IFoo)
        def __init__(self, foo):
            self.foo = foo

    #print adapter_for_protocol(IFoo, IBar)
    foo = Foo()
    assert IBar(foo).foo is foo


if __name__ == '__main__':
    import nose
    nose.main()
