from nose.tools import *

from adaptation.api import *
from adaptation.mime import *
from adaptation.wsgi import *
from adaptation.mime.xmldata import *

def test_rx():
    from adaptation.mime.mimetype import rx_charset
    assert rx_charset.search('text/html; charset=cp1251').group(1) == 'cp1251'

def test_basic():
    assert MimeType(major='text') is MimeType('text/*')
    assert assert_true, MimeType.HTML in MimeType.TEXT

def test_xml():
    assert isinstance(MimeType.XML('FOO'), XMLData)


def test_pax():
    mime_pax = 'application/padabam+xml'
    pax = MimeTypedData('a', mime_pax)
    #assert object_provides(pax) == set([MimeTypedData, MimeType(mime_pax), object]) #@@
    assert MimeType.XML in pax.mimetype.implied
    assert MimeType.XML(pax) is pax


def test_raise():
    assert_raises(ValueError, MimeTypedData, 'data', 'application/*')

## def test_adapters():
##     for f, t, a in [    (MimeTypedData, MimeType.ANY, Nop(1)),
##                         (MimeType.ANY, MimeTypedData, Break(0)),
##                         (MimeType.ANY, MimeType.IMAGE, Break(1)),
##                         (MimeType.VIDEO, MimeType.IMAGE, Break(2)),
##                 ]:
##         a0 = adapter_for_protocol(f, t)
##         yield assert_equals, a0, a
##     yield assert_equals, adapter_for_protocol(MimeTypedData, MimeType.XML).cost, 1
##


def test_webob():
    from webob import Request, Response

    def test(ob, type, charset):
        text = MimeType.TEXT(ob)
        assert text.mimetype is type
        assert text.charset == charset
        print `text`
        print `unicode(text)`

    resp = Response(unicode_body=u'FOO')
    test(resp, MimeType.HTML, 'UTF-8')

    req = Request.blank('/')
    req.unicode_body = u'FOO'
    req.content_type = MimeType.PLAIN
    test(req, MimeType.PLAIN, None)
    r = adapt(MimeType.PLAIN("TEXT"), Response)
    assert r.content_length == 4
    assert r.headers.get('content-type') == MimeType.PLAIN.typestr
    assert r.charset is None

## s = urllib.urlopen('http://google.com/')
## text = MimeType.TEXT(s)
## print text.mimetype, text.charset
## print unicode(text)[:40]
##




if __name__ == '__main__':
    import nose
    nose.main()
