from adaptation import *
from adaptation.wsgi import *
from adaptation.mime import *

from webob import Request, Response
from paste import urlmap

from nose.tools import *

def test():
    assert Request.blank('/').get_response(WSGI(None)).status_int == 404
    r = Response()
    assert WSGI(r) is r

def test_mime():
    text = MimeType.PLAIN('FOO')
    resp = adapt(text, Response)
    for wsgi in [adapt(resp, WSGI), adapt(text, WSGI), WSGI(text)]:
        yield assert_true, isinstance(wsgi, Response)

def test_paste():
    map = urlmap.URLMap()
    map['/'] = MimeType.PLAIN('ROOT')
    assert Request.blank('/').get_response(map).body == 'ROOT'
    assert_raises(TypeError, map.__getitem__, True, None)
    map['/404'] = None
    assert Request.blank('/404').get_response(map).status_int == 404


if __name__ == '__main__':
    import nose
    nose.main()
