#!/usr/bin/python
#coding:utf-8

from commands import getoutput
import os

class AnalyzeDir:
	def __init__(self,directory):
		self.directory = directory
		access = map((lambda x: True if os.path.isdir(x) else False), directory)
		if access:
			self.attrs = self.make_attr()
			self.directories = [i for i in self.attrs.keys() if self.attrs[i]["type"] == "d"]
			self.files = [j for j in self.attrs.keys() if self.attrs[j]["type"] != "d"]
			self.hidden = [k for k in self.attrs.keys() if k[0] == "."]
			self.result = True
		else: self.result = False
		
	def make_attr(self):
		locallist = self.call_files()
		attrs = {}
		for i in locallist:
			file_attrs = [j for j in i.split(" ") if j != ""]
			__name = file_attrs[-1]
			__access = self.calc(file_attrs[0])
			__type = file_attrs[0][0]
			__user = file_attrs[2]
			__group = file_attrs[3]
			__size = file_attrs[4]
			__date = "%s/%s-%s" % (file_attrs[5],file_attrs[6],file_attrs[7])
			
			attrs[__name] = {
						"access":__access,
						"type":  __type,
						"user":  __user,
						"group": __group,
						"size":  __size,
						"date":  __date}
		return attrs
			
			
	def calc(self,access):
		access = access[1:]
		acs = [access[:3],access[3:6],access[6:9]]
		items = []
		for i in acs:
			item = 0
			if "r" in i: item += 4
			if "w" in i: item += 2
			if "x" in i: item += 1
			
			items.append(item)
		return ''.join([str(i) for i in items])
		
	def call_files(self):
		body = getoutput("ls -lha").split("\n")[1:]
		return body