#!/usr/bin/env python
#coding: utf-8

import commands

class Analyzer:
	def __init__(self, directory):
		base = commands.getoutput("ls -ahl %s" % directory).splitlines()[1:]
		self.body = self.makebody(base)
		self.items = []
		for item in self.body:
			analyzer = self.analyze(item)
			d = {}
			d[ analyzer["item"] ] = {
				"parmission": analyzer["parmission"],
				"user"      : analyzer["user"],
				"group"     : analyzer["group"],
				"size"      : analyzer["size"],
				"date"      : analyzer["date"],
				"time"      : analyzer["time"]
			}
			self.items.append(d)
		self.items = tuple(self.items)
		
	#
	# Support Methods	
	# ---------------------------------
	def makebody(self, dirlist):
		items = []
		for line in dirlist:
			item = self.getlist(line.split(" "))
			items.append( tuple(item) )
		return items
		
	def getlist(self, string):
		return [i for i in string if i != ""]
		
	def analyze(self, diritem):
		result = {
			"parmission": self.calc(diritem[0]),
			"user"      : diritem[2],
			"group"     : diritem[3],
			"size"      : diritem[4],
			"date"      : "%s/%s" % ( diritem[5], diritem[6] ),
			"time"      : diritem[7],
			"item"      : diritem[8]
		}
		return result
		
	def calc(self, parm):
		parm = parm[1:]
		parmission = ( parm[:3], parm[3:6], parm[6:9] )
		item = []
		for i in parmission:
			j = 0
			if "r" in i: j += 4
			if "w" in i: j += 2
			if "x" in i: j += 1
			item.append(j)
		return ''.join( [str(i) for i in item] )