# -*- coding: utf-8 -*-

# Copyright 2013 Vincent Jacques
# vincent@vincent-jacques.net

# This file is part of AnotherPyGraphvizAgain. http://jacquev6.github.com/AnotherPyGraphvizAgain

# AnotherPyGraphvizAgain is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

# AnotherPyGraphvizAgain is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License along with AnotherPyGraphvizAgain.  If not, see <http://www.gnu.org/licenses/>.

import AnotherPyGraphvizAgain.Raw as raw


Node = raw.Node


class Link(raw.Link):
    def __init__(self, origin, destination):
        ltail = None
        lhead = None
        if isinstance(origin, Cluster):
            ltail = origin.id
            origin = origin.getOneNode()
        if isinstance(destination, Cluster):
            lhead = destination.id
            destination = destination.getOneNode()
        raw.Link.__init__(self, origin, destination)
        self.set("lhead", lhead)
        self.set("ltail", ltail)


class Graph(raw.Graph):
    def __init__(self, id):
        raw.Graph.__init__(self, id)
        self.set("compound", "true")


class Cluster(raw.Subgraph):
    def __init__(self, id):
        raw.Subgraph.__init__(self, "cluster_" + id)
