# -*- coding: utf-8 -*-

# Copyright 2013 Vincent Jacques
# vincent@vincent-jacques.net

# This file is part of AnotherPyGraphvizAgain. http://jacquev6.github.com/AnotherPyGraphvizAgain

# AnotherPyGraphvizAgain is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

# AnotherPyGraphvizAgain is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License along with AnotherPyGraphvizAgain.  If not, see <http://www.gnu.org/licenses/>.

import unittest
import os.path
import traceback


def ConstructionTestCase(Graph):
    class C(unittest.TestCase):
        def setUp(self):
            unittest.TestCase.setUp(self)

            self.g = Graph("First graph")
            self.expectedDotString = None

        def expect(self, dotString):
            self.expectedDotString = dotString
            self.testName = None
            for (_, _, functionName, _) in traceback.extract_stack():
                if functionName.startswith("test"):
                    self.testName = self.__class__.__name__ + "." + functionName
                    break
            self.assertIsNot(self.testName, None)

        def tearDown(self):
            if self.expectedDotString is not None:
                self.assertEqual(self.g.dotString(), self.expectedDotString)
                self.g.drawTo(os.path.join("AnotherPyGraphvizAgain", "tests", "drawings", self.testName + ".png"))

    return C
